//#region User Scripts
let scriptsDescriptors = [
  {
    _name: "Load Project Collection Data",
    _shortName: "iaf_dt_proj_colls",
    _description: "Load All Project Collections",
    _userType: "iaf_dt_proj_colls",
  },
  {
    _name: "BIMPK Upload",
    _shortName: "iaf_bimpk_upload",
    _description: "Load, Transform and Write Model from BIMPK",
    _userType: "iaf_bimpk_upload",
  },
  {
    _name: "SGPK Upload",
    _shortName: "iaf_sgpk_upload",
    _description: "Load, Transform and Write Model from BIMPK",
    _userType: "iaf_sgpk_upload",
  },
  {
    _name: "BIMPK Post Import - Copy Inverse Relations",
    _shortName: "iaf_bimpk_post_imp",
    _description:
      "BIMPK Post Import - Copy Inverse Relations from Prev Version",
    _userType: "iaf_bimpk_post_imp",
  },
  {
    _name: "Re-mapping type elements",
    _shortName: "iaf_map_elms_type",
    _description: "Update model type elements, after BIMtypes updated",
    _userType: "iaf_map_elms_type",
  },
  {
    _name: "Model Reporting and Validation",
    _shortName: "iaf_ext_val_scr",
    _description: "Scripts to Inspect Model Content and Generate Reports",
    _userType: "iaf_ext_val_scr",
  },
  {
    _name: "Files As Entities All Users",
    _shortName: "iaf_files_allusers",
    _description: "Files for Entity View",
    _userType: "iaf_files_allusers",
  },
  {
    _name: "Files As Entities All Users",
    _shortName: "iaf_dt_model_elems",
    _description: "Model elements",
    _userType: "iaf_dt_model_elems",
  },
  {
    _name: "BMS Equipment Entity scripts",
    _shortName: "iaf_bms_allusers",
    _description: "BMS data as entities",
    _userType: "iaf_bms_allusers",
  },
  {
    _name: "Object Model API Scripts",
    _shortName: "iaf_obj_model_api",
    _description: "Object Model API Asset Script",
    _userType: "iaf_obj_model_api",
  },
  {
    _name: "Import Data Sheets",
    _shortName: "iaf_import_data_sheets",
    _description: "Import Data Sheets",
    _userType: "iaf_import_data_sheets",
  },
  {
    _name: "Orchestrator",
    _shortName: "orchestrator",
    _description: "Schedule orchestrator",
    _userType: "orchestrator",
  },
  {
    _name: "iot_normalization",
    _shortName: "iot_normalization",
    _description: "Script to normalize readings",
    _userType: "telemetry_parser_script",
  },
  // {
  //   _name: "Entity Relations Scripts",
  //   _shortName: "iaf_relations_scripts",
  //   _description:
  //     "Scripts to manage (CRUD) parent-child relations between entities",
  //   _userType: "iaf_relations_scripts"
  // },
  {
    _name: "Export Data Sheets",
    _shortName: "iaf_export_data_sheets",
    _description: "Export Data Sheets",
    _userType: "iaf_export_data_sheets",
  },
  {
    _name: "Schemas Scripts",
    _shortName: "iaf_schemas_allusers",
    _description: "Scripts to handle schemas",
    _userType: "iaf_schemas_allusers",
  },
  {
    _name: "Pick List Scripts",
    _shortName: "iaf_pick_lists",
    _description: "Scripts to work with pick lists",
    _userType: "iaf_pick_lists",
  },
  {
    _name: "System Scripts",
    _shortName: "iaf_systems_scripts",
    _description: "Scripts to work with systems",
    _userType: "iaf_systems_scripts",
  },
  {
    _name: "BIMPK Upload Stream",
    _shortName: "iaf_import_model",
    _description: "Load, Transform and Write Model from BIMPK",
    _userType: "iaf_import_model",
  },
  {
    _name: "Files Page Scripts",
    _shortName: "iaf_files_page",
    _description: "Scripts for loading files and folders on the Files Page",
    _userType: "iaf_files_page"
  },
  {
    _name: "Mapbox Scripts",
    _shortName: "iaf_mapbox",
    _description: "Mapbox token request api",
    _userType: "iaf_mapbox"
  }
];
//#endregion

const scriptNames = [
  "iaf_dt_proj_colls",
  "iaf_bimpk_upload",
  "iaf_bimpk_post_imp",
  "iaf_map_elms_type",
  "iaf_files_allusers",
  "iaf_dt_model_elems",
  "iaf_obj_model_api",
  "iaf_import_data_sheets",
  "orchestrator",
  "iot_normalization",
  "iaf_import_model",
  "iaf_files_page",
  "iaf_mapbox"
];

function Utf8ArrayToStr(array) {
  var out, i, len, c;
  var char2, char3;

  out = "";
  len = array.length;
  i = 0;
  while (i < len) {
    c = array[i++];
    switch (c >> 4) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
        // 0xxxxxxx
        out += String.fromCharCode(c);
        break;
      case 12:
      case 13:
        // 110x xxxx   10xx xxxx
        char2 = array[i++];
        out += String.fromCharCode(((c & 0x1f) << 6) | (char2 & 0x3f));
        break;
      case 14:
        // 1110 xxxx  10xx xxxx  10xx xxxx
        char2 = array[i++];
        char3 = array[i++];
        out += String.fromCharCode(
          ((c & 0x0f) << 12) | ((char2 & 0x3f) << 6) | ((char3 & 0x3f) << 0)
        );
        break;
    }
  }

  return out;
}

async function uploadScripts(params, libraries, ctx) {
  console.log("Started Upload Scripts...");
  console.log("uploadScripts params: ", JSON.stringify(params));
  console.log("uploadScripts ctx: ", JSON.stringify(ctx));
  return new Promise(async (resolve, reject) => {
    try {
      const { PlatformApi, IafScriptEngine, fs, path } = libraries;
      let project = params.actualParams.project._list[0];
      const { zipLink } = params.actualParams;
      let scripts = [];

      //* Download project setup zip file
      const response = await fetch(zipLink);
      const directoryPath = response.unZippedFilePath;
      const filePath = `${directoryPath}/scripts`;
      await readFilesRecursively(filePath);

      async function readFilesRecursively(dir) {
        const files = await fs.readdirSync(dir);
        for (const file of files) {
          const filePath = `${dir}/${file}`;
          if (!file.includes(".")) {
            await readFilesRecursively(filePath); // Await the recursive call
          } else {
            try {
              for (let i = 0; i < scriptNames.length; i++) {
                const fileData = await fs.readFileSync(filePath);
                const scriptName = scriptNames[i];
                if (scriptName === file.split(".")[0]) {
                  const scriptContent = Utf8ArrayToStr(fileData);
                  scripts.push({ scriptName, scriptContent });
                }
              }
            } catch (error) {
              null;
            }
          }
        }
      }

      let result = await PlatformApi.IafProj.getScriptsByProjectId(
        project._id,
        ctx
      );
      console.log("Getting project's available scripts response", result);

      //* Importing all modules
      if (result && result._list && result._list.length > 0) {
        let scripts = result._list;
        scripts.forEach(async (s) => {
          let obj = await import(
            PlatformApi.IafItemSvc.getScriptContentUrl(s._id, ctx)
          );
          console.log(`Module Imported ${s._name}`);
        });
      }

      let scriptItems = [];
      scripts.forEach((c) => {
        let item = scriptsDescriptors.find(
          (obj) => obj._shortName === c.scriptName
        );
        if (item) {
          item._version = { _userData: c.scriptContent };
          item._namespaces = project._namespaces;
          scriptItems.push(item);
        }
      });
      console.log("Script items with information.", scriptItems);

      //* Creating script in project
      let createScriptRes = await PlatformApi.IafScripts.create(
        scriptItems,
        ctx
      );
      console.log("Created Scripts", createScriptRes);
      resolve(createScriptRes);
    } catch (err) {
      console.log(err);
      reject(err);
    }
  });
}
