/**
 * ****************************************************************************
 *
 * INVICARA INC CONFIDENTIAL __________________
 *
 * Copyright (C) [2012] - [2023] INVICARA INC, INVICARA Pte Ltd, INVICARA INDIA
 * PVT LTD All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Invicara Inc and its suppliers, if any. The intellectual and technical
 * concepts contained herein are proprietary to Invicara Inc and its suppliers
 * and may be covered by U.S. and Foreign Patents, patents in process, and are
 * protected by trade secret or copyright law. Dissemination of this information
 * or reproduction of this material is strictly forbidden unless prior written
 * permission is obtained from Invicara Inc.
 */

const path = require("path");
const { CleanWebpackPlugin } = require("clean-webpack-plugin");
const HtmlWebpackPlugin = require("html-webpack-plugin");
const CopyWebpackPlugin = require("copy-webpack-plugin");
const TerserJSPlugin = require("terser-webpack-plugin");
const NodePolyfillPlugin = require("node-polyfill-webpack-plugin");
// const BundleAnalyzerPlugin =
//   require('webpack-bundle-analyzer').BundleAnalyzerPlugin

module.exports = {
  entry: ["regenerator-runtime/runtime", "./app/client/index.jsx"],
  output: {
    filename: 'index.[contenthash:8].js',
    path: path.resolve(__dirname, "build/reference"),
    publicPath: "/reference/",
    clean: true,
    assetModuleFilename: 'static/media/[name].[contenthash:8].[ext]',
  },
  devServer: {
    historyApiFallback: {
      rewrites: [
        { from: /^\/reference\/favicon.png$/, to: "/reference/favicon.png" },
        { from: /^\/reference\/helpers.js$/, to: "/reference/helpers.js" },
        { from: /^\/reference\/config.js$/, to: "/reference/config.js" },
        { from: /^\/reference\/version.js$/, to: "/reference/version.js" },
        { from: /^\/reference/, to: "/reference/" },
      ],
    },
    static: './build/reference'
  },
  mode: "development",
  optimization: {
    minimize: true,
    minimizer: [
      new TerserJSPlugin({
        terserOptions: {
          keep_fnames: true,
        },
      }),
    ],
    splitChunks: {
      chunks: "all",
    },
    usedExports : true
  },
  plugins: [
    new NodePolyfillPlugin(),
    new CleanWebpackPlugin(),
    new HtmlWebpackPlugin({
      template: "app/public/index.html",
      inject: "body",
    }),
    new CopyWebpackPlugin({
      patterns: [
        { from: "app/public/favicon.png", to: "favicon.png" },
        { from: "app/public/config.js", to: "config.js" },
        { from: "app/public/version.js", to: "version.js" },
        { from: "app/public/helpers.js", to: "helpers.js" },
        { from: "app/public/docs.png", to: "docs.png" },
        {
          from: '*.zip',
          to: 'project_setup/[name].zip',
          noErrorOnMissing: true // This line suppresses errors if no .zip files are found
        },
        { from: "app/public/invicara/sprites", to: "invicara/sprites", toType: "dir" },
        { from: "app/public/invicara/models", to: "invicara/models", toType: "dir" },
        // { from: "app/public/mirrana/", to: "mirrana/", toType: "dir" },
        {from: 'app/public/pdf/', to: 'pdf/', toType: 'dir'},
        // {
        //   from: "node_modules/@dtplatform/iaf-viewer/dist/lib/",
        //   to: "lib/",
        //   toType: "dir",
        // },
        {
          from: "app/public/invicara/simple_navigator.png",
          to: "simple_navigator.png",
        },
        
        {
          from: "app/public/invicara/simple_files.png",
          to: "simple_files.png",
        },
        {
          from: "app/public/invicara/simple_spaces.png",
          to: "simple_spaces.png",
        },
        {
          from: "app/public/invicara/simple_assets.png",
          to: "simple_assets.png",
        },
        { from: "app/public/mirrana/mirranaLogo.svg", to: "mirranaLogo.svg" },
        { from: "app/public/invicara/logo.png", to: "logo.png" },
        {
          from: "app/public/mirrana/simple_navigator_mirrana.svg",
          to: "simple_navigator_mirrana.svg",
        },
        {
          from: "app/public/mirrana/simple_assets_mirrana.svg",
          to: "simple_assets_mirrana.svg",
        },
        {
          from: "app/public/mirrana/simple_files_mirrana.svg",
          to: "simple_files_mirrana.svg",
        },
        {
          from: "app/public/invicara/simple_navigator.svg",
          to: "simple_navigator.svg",
        },
        {
          from: "app/public/invicara/simple_assets.svg",
          to: "simple_assets.svg",
        },
        {
          from: "app/public/invicara/simple_files.svg",
          to: "simple_files.svg",
        },
      ],
    }),
    // new BundleAnalyzerPlugin(),
  ],
  resolve: {
    extensions: [".js", ".jsx", ".json"],
    fallback : {
      canvas : false,
      fs : false
    }
  },
  module: {
    rules: [
      {
        test: [/\.bmp$/, /\.gif$/, /\.jpe?g$/, /\.png$/,/\.svg$/],
        exclude: [
          /\.html$/,
          /\.(js|jsx|mjs)$/,
          /\.css$/,
          /\.scss$/,
          /\.less$/,
          /\.json$/,
          /\.bmp$/,
          /\.gif$/,
          /\.jpe?g$/,
          /\.png$/,
          /\.scs$/,
          /\.(glsl|vs|fs)$/
        ],
        type: 'asset/resource',
      },
      {
        test: /\.m?js$/,
        resolve: {
          fullySpecified: false,
        },
      },
      {
        test: /\.(js|jsx)?$/,
        use: {
          loader: "babel-loader",
          options: {
            presets: ["@babel/preset-env", "@babel/preset-react"],
            plugins: [
              require("@babel/plugin-external-helpers"),
              require("@babel/plugin-proposal-object-rest-spread"),
              require("fast-async"),
              ["@babel/plugin-proposal-class-properties", { loose: true }],
              ["@babel/plugin-proposal-private-methods", { loose: true }],
              [
                "@babel/plugin-proposal-private-property-in-object",
                { loose: true },
              ],
            ],
          },
        },
        include: path.resolve(__dirname, "app"),
        exclude: [/node_modules/],
      },
      {
        test: /\.(scss)$/,
        use: [
          { loader: "style-loader" },
          { loader: "css-loader" },
          { loader: "sass-loader" },
        ],
      },
      {
        test: /\.(css)$/,
        use: [{ loader: "style-loader" }, { loader: "css-loader" }],
      },
      {
        test: /\.less$/,
        use: [
          { loader: "style-loader" },
          { loader: "css-loader" },
          { loader: "less-loader" },
        ],
      },
      {
        test: /\.(glsl|vs|fs)$/,
        loader: "webpack-glsl-loader",
      },
    ],
  },
};
